/*
	֗ȕ񏈗p֐
*/

#ifndef STRUTIL_H
#define STRUTIL_H

#include <ctype.h>
#include <string.h>
#include <stdbool.h>

#ifdef __cplusplus
extern "C" {
#endif

/*-----------------------------------------------
	֐vg^Cv
-----------------------------------------------*/

/*
	strutilCopy
	
	WCustrncpy()ɎĂ邪AKNULLtB
	
	@param: char *dest
		̃Rs[B
		̃|C^ɌX܂ẮAsrcŏ㏑ꎸB
	
	@param: const char *src
		̃Rs[B
		̕destփRs[B
	
	@param: size_t max
		Rs[ő啶B
		NULL܂ށB
		1ł͏NULL݂̂A0ł͂ȂɂȂB
	
	@return: char*
		Rs[ԂB
		kB
*/
int strutilCopy( char *__restrict__ dest, const char *__restrict__ src, size_t max );
int strutilNCopy( char *__restrict__ dest, const char *__restrict__ src, size_t n, size_t max );

/*
	strutilCat
	
	WCustrncat()ɎĂ邪AKNULLtB
	܂ATCYsrc̕ł͂ȂA̍ő啶B
	܂Adest͕KmaxȉɂȂB
	dest + src̕max傫ꍇ́Asrc͑SăRs[ȂB
	
	@param: char *dest
		B̌srcB
	
	@param: const char *src
		镶Bdesťɂ̕񂪌B
	
	@param: size_t max
		̍ő啶B
		dest͕K̒ȉɂȂB
	
	@return: char*
		̕ԂB
		kB
*/
int strutilCat( char *__restrict__ dest, const char *__restrict__ src, size_t max );
int strutilNCat( char *__restrict__ dest, const char *__restrict__ src, size_t n, size_t max );

/*
	strutilCounterPbrk
	
	WCustrpbrk()ɎĂ邪A
	srcɁAsearcĥꂩ"܂܂Ȃ"ŏɌʒuԂB
	
	@param: const char *src
		ΏەB
	
	@param: const char *search
		QB
	
	@return: char*
		"srcŁAQsearchɊ܂܂ȂŏɌʒuB
*/
char *strutilCounterPbrk( const char *__restrict__ src, const char *__restrict__ search );

/*
	strutilCounterReversePbrk
	
	LstrutilCounterPbrk()ƓƂA̖猟B
	
	@param: const char *src
		ΏەB
	
	@param: const char *search
		QB
	
	@return: char*
		"srcŁAQsearchɊ܂܂ȂŏɌʒuB
*/
char *strutilCounterReversePbrk( const char *__restrict__ src, const char *__restrict__ search );

/*
	strutilRemoveChar 
	
	񂩂Aw肵폜Aɋl߂B
	
	@param: char *str
		Ώۂ̕B
	
	@param: const char *search
		菜wB
		Ŏw肷邪A菜SďoB
*/
void strutilRemoveChar( char *__restrict__ str, const char *__restrict__ search );

/*
	strutilToUpperFirst
	
	̐擪啶ɕϊB
	
	@param: char *str
		ϊΏەB
	
	@return: char*
		strԂB
*/
char *strutilToUpperFirst( char *str );

/*
	strutilToLowerFirst
	
	̐擪ɕϊB
	
	@param: char *str
		ϊΏەB
	
	@return: char*
		strԂB
*/
char *strutilToLowerFirst( char *str );

/*
	strutilCountChar
	
	񒆂Ɋ܂܂镶̐𐔂B
	
	@param: char *str
		ΏەB
	
	@param: char c
		B
	
	@return: unsigned int
		B
*/
unsigned int strutilCountChar( const char *str, char c );

#ifdef __cplusplus
}
#endif

#endif
